    </div> <!-- Cierra el div flex de header.php -->
</main> <!-- Cierra el main que se abrió en dashboard.php -->

<!-- Scripts globales (toggle sidebar, cambio de tema) y gráficos -->
<script>
    const sidebar = document.getElementById('sidebar');
    const sidebarOverlay = document.getElementById('sidebar-overlay');
    const themeBtn = document.getElementById('theme-btn');
    const html = document.documentElement;
    const sidebarLogo = document.getElementById('sidebar-logo');

    function toggleSidebar() {
        sidebar.classList.toggle('-translate-x-full');
        sidebarOverlay.classList.toggle('hidden');
    }

    function updateLogo() {
        if (!sidebarLogo) return;
        sidebarLogo.src = html.classList.contains('dark') ? '../public/img/logo-jfd-dark.png' : '../public/img/logo-jfd.png';
    }

    // Inicializar tema
    if (localStorage.getItem('theme') === 'light') html.classList.remove('dark');
    else html.classList.add('dark');
    updateLogo();

    themeBtn.addEventListener('click', () => {
        html.classList.toggle('dark');
        localStorage.setItem('theme', html.classList.contains('dark') ? 'dark' : 'light');
        updateLogo();
    });

    // --- GRÁFICOS (dependen de las variables PHP) ---
    Chart.defaults.font.family = "'Barlow', sans-serif";
    Chart.defaults.color = '#888';

    // Gráfico Barras (Marcas)
    new Chart(document.getElementById('brandChart'), {
        type: 'bar',
        data: {
            labels: <?php echo json_encode(array_column($brandData, 'name')); ?>,
            datasets: [{
                label: 'Productos',
                data: <?php echo json_encode(array_column($brandData, 'total')); ?>,
                backgroundColor: '#D90429',
                borderRadius: 10,
                barThickness: 35
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: { legend: { display: false } },
            scales: { 
                y: { beginAtZero: true, grid: { color: 'rgba(150,150,150,0.1)', drawBorder: false } },
                x: { grid: { display: false } }
            }
        }
    });

    // Gráfico Dona (Categorías)
    new Chart(document.getElementById('categoryChart'), {
        type: 'doughnut',
        data: {
            labels: <?php echo json_encode(array_column($catData, 'name')); ?>,
            datasets: [{
                data: <?php echo json_encode(array_column($catData, 'total')); ?>,
                backgroundColor: ['#D90429', '#121212', '#444', '#888', '#ccc'],
                borderWidth: 0,
                hoverOffset: 20
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '80%',
            plugins: { legend: { position: 'bottom', labels: { usePointStyle: true, padding: 30, font: { weight: 'bold', size: 10 } } } }
        }
    });
</script>

</body>
</html>